﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Wyliczenie podstawy zasiłku</title>
		<script runat="server">

            public class _SrInfo : SerializableContextBase {
                public _SrInfo(Context context) : base(context) {
                }

                bool zerowe;
                [Caption("Pokaż elementy zerowe")]
                public bool Zerowe {
                    get { return zerowe; }
                    set {
                        zerowe = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool zaokraglenie;
                [Caption("Zaokrąglenie kolumny J")]
                public bool Zaokraglenie {
                    get { return zaokraglenie; }
                    set {
                        zaokraglenie = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            _SrInfo srinfo;
            [SettingsContext]
            public _SrInfo SrInfo {
                set { srinfo = value; }
            }
        
            public enum GrupaDanych {
                Pusta,
                Miesięczne,
                Okresowe,
                Podsumowanie
            }
                            
            class Rekord1 {
                public enum RodzajDanych {
                    Pusty,
                    Opis,
                    Dane
                }
                
                private string okres;
                public string Okres {
                    get { return okres; }
                }
                
                private string sposob;
                public string Sposob {
                    get { return sposob; }
                }

                private decimal brutto;
                public decimal Brutto {
                    get { return brutto; }
                }

                private decimal podstawa;
                public decimal Podstawa {
                    get { return podstawa; }
                }
                
                private string element;
                public string Element {
                    get { return element; }
                }
                
                private string mnoznik;
                public string Mnoznik {
                    get { return mnoznik; }
                }
                
                private string odchylki;
                public string Odchylki {
                    get { return odchylki; }
                }
                
                RodzajDanych rodzaj;
                public RodzajDanych Rodzaj {
                    get { return rodzaj; }
                }

                private bool odczytaj;

                public Rekord1(string okr, string row) {
                    rodzaj = RodzajDanych.Pusty;
                    odczytaj = false;
                    okres = okr;
                    Dodaj(row);
                }
                                                                
                public void Dodaj(string row) {
                    string[] cols = row.Split('|');
                    if (cols.Length != 6) {
                        Opis(row);
                        return;
                    }

                    int nr = 0;
                    string str;
                    foreach (string col in cols) {
                        str = col.Trim();
                        switch (nr++) {
                            case 0:
                                sposob = str; break;
                            case 1:
                                try { brutto = decimal.Parse(str.Replace(".", ",")); }
                                catch { return; }
                                break;
                            case 2:
                                try { podstawa = decimal.Parse(str.Replace(".", ",")); }
                                catch { return; }
                                break;
                            case 3:
                                element = str; break;
                            case 4:
                                mnoznik = str; break;
                            case 5:
                                odchylki = str; break;
                        }
                    }
                    rodzaj = RodzajDanych.Dane;
                }

                public void Opis(string opis) {
                    string label1 = "Dane pobrane z wprowadzonej podstawy";
                    string label2 = "miesiąca: ";
                    string label3 = "miesiącu: ";
                    string label4 = " PLN,";
                    string label5 = "Bez dopełnienia: ";

                    if (opis.EndsWith("."))
                        opis = opis.Substring(0, opis.Length - 1);

                    if (opis.StartsWith(label5)) {
                        opis = opis.Replace(label5, "").Trim();
                        try {
                            sposob = label5.Substring(0, label5.Length - 2);
                            podstawa = decimal.Parse(opis.Substring(0, opis.IndexOf(label4)).Trim().Replace(".", ","));
                            element = opis.Substring(opis.IndexOf(label4) + label4.Length);
                        }
                        catch { }
                    }
                    else {
                        if (!okres.Contains(" - "))
                            okres += " - ";
                        else
                            okres += ", ";
                        okres += opis;
                    }

                    if (opis.StartsWith(label1))
                        odczytaj = true;
                    else if (odczytaj && opis.Contains(label4) && (opis.Contains(label2) || opis.Contains(label3)))
                        try {
                            int sp = opis.IndexOf(label2);
                            if (sp == -1)
                                sp = opis.IndexOf(label3);
                            sp += label2.Length;
                            int ep = opis.IndexOf(label4, sp);
                            podstawa = decimal.Parse(opis.Substring(sp, ep-sp).Replace(".", ","));
                        }
                        catch { }
                    rodzaj = RodzajDanych.Opis;
                }
            }

            class Rekord2 {
                readonly _SrInfo srinfo;
                
                private string okres;
                public string Okres {
                    get { return okres; }
                }
                
                private string sposob;
                public string Sposob {
                    get { return sposob; }
                }

                private decimal brutto;
                public decimal Brutto {
                    get { return brutto; }
                }

                private decimal podstawa;
                public decimal Podstawa {
                    get { return podstawa; }
                }

                private bool podwojona;
                public string Podwojona {
                    get { return podwojona ? "TAK" : "NIE"; }
                }
                
                private string element;
                public string Element {
                    get { return element; }
                }

                private int mnoznik;
                public int Mnoznik {
                    get { return mnoznik; }
                }

                private string odchylki;
                public string Odchylki {
                    get { return odchylki; }
                }

                private string wspolczynnik;
                public string Wspolczynnik {
                    get { return wspolczynnik; }
                }

                private decimal wartosc;
                public decimal Wartosc {
                    get { return wartosc; }
                }

                private decimal kwota;
                public decimal Kwota {
                    get { return kwota; }
                }
                                                
                bool pusty = true;
                public bool Pusty {
                    get { return pusty; }
                }

                public Rekord2(string row, _SrInfo srinfo) {
                    this.srinfo = srinfo;
                    string[] cols = row.Split('|');
                    if (cols.Length != 6)
                        return;

                    int nr = 0;
                    string str;
                    foreach (string col in cols) {
                        str = col.Trim();
                        switch (nr++) {
                            case 0:
                                sposob = str; break;
                            case 1:
                                try {
                                    wartosc = brutto = kwota = decimal.Parse(str.Replace(".", ","));
                                    if (srinfo.Zaokraglenie)
                                        kwota = Soneta.Tools.Math.Round(kwota, 4);
                                }
                                catch { return; }
                                break;
                            case 2:
                                try { podstawa = decimal.Parse(str.Replace(".", ",")); }
                                catch { return; }
                                break;
                            case 3:
                                element = str; break;
                            case 4:
                                okres = str; break;
                            case 5:
                                odchylki = str; break;
                        }
                    }
                    pusty = false;
                }

                public void Dodaj(string row) {
                    string[] cols = row.Split('|');
                    if (cols.Length != 8)
                        return;

                    int nr = 0;
                    string str;
                    foreach (string col in cols) {
                        str = col.Trim();
                        switch (nr++) {
                            case 1:
                                podwojona = (str == "w podwójnej wysokości"); break;
                            case 3:
                                wspolczynnik = str; break;
                            case 5:
                                try { wartosc = decimal.Parse(str.Replace(".", ",")); }
                                catch { }
                                break;
                            case 7:
                                try { mnoznik = int.Parse(str); }
                                catch { }
                                break;
                        }
                    }
                    if (mnoznik != 0) kwota = wartosc / mnoznik;
                    if (srinfo.Zaokraglenie)
                        kwota = Soneta.Tools.Math.Round(kwota, 4);
                }
            }

            class Rekord2Comparer : IComparer {
                public int Compare(object px, object py) {
                    Rekord2 x = (Rekord2)px;
                    Rekord2 y = (Rekord2)py;
                    int result = x.Element.CompareTo(y.Element);
                    if (result == 0)
                        result = x.Okres.CompareTo(y.Okres);
                    return result;
                }
            }
            
            protected void OnContextLoad(object sender, EventArgs e) {
                WypElement wen = (WypElement)dc[typeof(WypElement)];
                PracHistoria ph = wen.Wyplata.PracHistoria;

		        CoreModule core = CoreModule.GetInstance(dc);
                string nazwa = core.Config.Firma.Pieczątka.Nazwa;
                string nip = core.Config.Firma.Pieczątka.NIP;
                string adres1 = core.Config.Firma.AdresSiedziby.Linia1;
                string adres2 = core.Config.Firma.AdresSiedziby.Linia2;
                if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                    OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                    if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
                    if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
                    if (!string.IsNullOrEmpty(of.Adres.Linia1)) adres1 = of.Adres.Linia1;
                    if (!string.IsNullOrEmpty(of.Adres.Linia2)) adres2 = of.Adres.Linia2;
                }
                dlFirma.EditValue = string.Format("<strong>{0}</strong>", nazwa.Replace("&","&amp;"));
                dlAdres1.EditValue = adres1;
                dlAdres2.EditValue = adres2;
                dlNIP.EditValue = string.Format("NIP: {0}", nip);
                dlData.EditValue = Date.Today.ToString();

                WypElement we = null;
                try {
                    WypElementNieobecność.PokażŹródłoPodstawyWorker pzp = new WypElementNieobecność.PokażŹródłoPodstawyWorker();
                    pzp.ElementPodstawy = wen;
                    we = pzp.PokażElement();
                }
                catch { }
                
                scKorekta.Visible = wen.Korekta;
                scPoprzednia.Visible = (we != null);

                dlPracownik.EditValue = wen.Wyplata.Pracownik;
                dlElement.EditValue = wen.Definicja.Nazwa;
                dlOkres.EditValue = wen.Okres;
                dlKwota.EditValue = new Currency(wen.Wartosc);
                dlPodstawa.EditValue = wen.SkładnikGłówny != null ? wen.SkładnikGłówny.Podstawa1.ToString() : "";
                dlProcent.EditValue = wen.SkładnikGłówny != null ? wen.SkładnikGłówny.Procent.ToString() : "";
                dlDni.EditValue = wen.SkładnikGłówny != null ? wen.SkładnikGłówny.Dni.ToString() : "";
                dlLista.EditValue = wen.Wyplata.ListaPlac;

                if (we != null) {
                    dlPoprzednia.EditValue = we.Okres;
                    wen = we;
                }
                
                ArrayList list1 = new ArrayList();
                ArrayList list2 = new ArrayList();
                
                string header1 = "Sposób wliczania";
                string header2 = "Podstawa zasiłków ZUS z kadr z miesiąca:";
                string header3 = "Elementy okresowe";
                string header4 = "Podstawa chorobowego wyliczona z danych kadrowych:";
                string footer1 = "Suma podstaw";
                string footer2 = "Liczba uwzględnionych miesięcy";
                string footer3 = "Średnia podstawa";
                string footer4 = "Podstawa chorobowego";
                string footer5 = "Podstawa pobrana";
                string label1 = "Miesiąc:";
                string label2 = "Odrzucony miesiąc:";
                string month = "";
                string total = "";
                string srednia = "";

                Rekord1 r1 = null;
                Rekord2 r2 = null;
                GrupaDanych grupa = GrupaDanych.Pusta;

                string[] rows = wen.ZapisObliczen.ToArray();
                foreach (string row in rows) {
                    if (row.StartsWith(header1) || row.StartsWith(header2) || row.StartsWith(header4))
                        grupa = GrupaDanych.Miesięczne;
                    else if (row.StartsWith(header3))
                        grupa = GrupaDanych.Okresowe;
                    else if (row.StartsWith(footer1) || row.StartsWith(footer2) || row.StartsWith(footer3) ||
                             row.StartsWith(footer4) || row.StartsWith(footer5))
                        grupa = GrupaDanych.Podsumowanie;
                    
                    if (grupa == GrupaDanych.Miesięczne) {
                        if (row.StartsWith(label1)) {
                            month = row.Replace(label1, "").Trim();
                            r1 = null;
                        }
                        else if (row.StartsWith(label2)) {
                            month = row.Replace(label2, "").Trim();
                            r1 = new Rekord1(month, row.Substring(0, label2.Length-1));
                            list1.Add(r1);
                        }
                        else if (row.StartsWith(header2)) {
                            month = row.Replace(header2, "").Trim();
                            r1 = null;
                        }
                        else if (row.StartsWith(header4)) {
                            foreach (Rekord1 r in list1)
                                if (r.Okres.StartsWith(month))
                                    r.Opis(row.Substring(0, header4.Length-1));
                        }
                        else if (month != "") {
                            Rekord1 rr = new Rekord1(month, row);
                            if (rr.Rodzaj != Rekord1.RodzajDanych.Pusty) {
                                if (r1 == null)
                                    list1.Add(rr);
                                else if (rr.Rodzaj == Rekord1.RodzajDanych.Dane)
                                    list1.Add(rr);
                                else if (rr.Rodzaj == Rekord1.RodzajDanych.Opis)
                                    foreach (Rekord1 r in list1)
                                        if (r.Okres.StartsWith(month))
                                            r.Opis(row);
                                r1 = rr;
                            }
                        }
                    }
                    else if (grupa == GrupaDanych.Okresowe) {
                        if (row.StartsWith(" ") && r2 != null)
                            r2.Dodaj(row);
                        else {
                            r2 = new Rekord2(row, srinfo);
                            if (!r2.Pusty)
                                list2.Add(r2);
                            else
                                r2 = null;
                        }
                    }
                    else if (grupa == GrupaDanych.Podsumowanie)
                        if (!row.StartsWith("*")) {
                            total += row + "\r\n";
                            if (row.StartsWith(footer2) || row.StartsWith(footer3))
                                srednia += row + "\r\n";
                        }
                }

                Grid1.DataSource = list1;

                scSrednia.Visible = (srednia != "");
                dlSrednia.EditValue = srednia;
                
                list2.Sort(new Rekord2Comparer());
                Grid2.DataSource = list2;
                
                string total1 = "Suma podstaw bez dodatków okresowych:";
                string total1N = "Suma podstaw bez dodatków okresowych (I):";

                string total2 = "Podstawa chorobowego (tylko dodatki okresowe):";
                string total2N = "Podstawa chorobowego (tylko dodatki okresowe) (II: suma kolumny J):";

                string total3 = "Podstawa chorobowego:";
                string total3N = "Podstawa chorobowego (I+II):";

                total = total.Replace(total1, total1N);
                total = total.Replace(total2, total2N);
                total = total.Replace(total3, total3N);
                
                dlPodsumowanie.EditValue = total;
            }

            void Grid1_OnBeforeRow(object sender, RowEventArgs args) {
                Rekord1 r1 = (Rekord1)args.Row;
                if (!srinfo.Zerowe && r1.Brutto == 0 && r1.Podstawa == 0)
                    args.VisibleRow = false;
            }

            void Grid2_OnBeforeRow(object sender, RowEventArgs args) {
                Rekord2 r2 = (Rekord2)args.Row;
                if (!srinfo.Zerowe && r2.Brutto == 0 && r2.Podstawa == 0)
                    args.VisibleRow = false;
            }
		    
        </script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true"></ea:DataContext>
                <table cellSpacing="0" width="100%" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-family: tahoma; text-align:left;">
			        <tr>
            		    <td width="35%" valign="top" align="left" style="border-width: 1px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 9pt;">
				            <ea:datalabel id="dlFirma" runat="server" Bold="false"></ea:datalabel><br /> 
				            <ea:datalabel id="dlAdres1" runat="server" Bold="false"></ea:datalabel><br /> 
				            <ea:datalabel id="dlAdres2" runat="server" Bold="false"></ea:datalabel><br /> 
				            <ea:datalabel id="dlNIP" runat="server" Bold="false"></ea:datalabel><br /> 
                        </td>
            		    <td width="1%" style="border-width: 0px 0px 0px 0px;">&nbsp;</td>
            		    <td width="64%" valign="middle" align="left" style="border-width: 1px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 11pt;">
                            <b>Wyliczenie podstawy nieobecności ZUS</b>
                            <br />
                            <font style="font-size: 9pt;">
                                <b>Data wydruku:</b>
                                <ea:DataLabel ID="dlData" runat="server"></ea:DataLabel>
                            </font>
                        </td>
                    </tr>
                </table>
                <ea:Section runat="server" ID="scKorekta">
                    <br />
                    <font face="Tahoma" color="red" size="2">
                        Korekta ręczna elementu
                    </font>
                    <br />
                </ea:Section>
                <ea:Section runat="server" ID="scPoprzednia">
                    <br />
                    <font face="Tahoma" color="red" size="2">
                        Podstawa pobrana z poprzedniej nieobecności z okresu:
                        <ea:DataLabel ID="dlPoprzednia" runat="server"></ea:DataLabel>
                    </font>
                    <br />
                </ea:Section>
                <ea:Section runat="server" ID="scSzczegoly">
                    <br />
                    <font face="Tahoma" size="2">
                        Pracownik: <ea:DataLabel ID="dlPracownik" runat="server"></ea:DataLabel><br />
                        Wypłata: <ea:DataLabel ID="dlElement" runat="server"></ea:DataLabel><br />
                        Za okres: <ea:DataLabel ID="dlOkres" runat="server"></ea:DataLabel><br />
                        Kwota: <ea:DataLabel ID="dlKwota" runat="server"></ea:DataLabel><br />
                        Podstawa: <ea:DataLabel ID="dlPodstawa" runat="server"></ea:DataLabel><br />
                        Procent: <ea:DataLabel ID="dlProcent" runat="server"></ea:DataLabel><br />
                        Liczba dni zasiłkowych: <ea:DataLabel ID="dlDni" runat="server"></ea:DataLabel><br />
                        Lista płac: <ea:DataLabel ID="dlLista" runat="server"></ea:DataLabel><br />
                    </font>
                    <br />
                </ea:Section>
                <font face="Tahoma" size="2">
                    <b>I. SKŁADNIKI NALEŻNE ZA OKRESY NIE DŁUŻSZE NIŻ 1 MIESIĄC</b>
                </font>
			    <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_OnBeforeRow"
                    GroupLine="{0}" GroupData0="Okres" ShowGroupSum="true">
				    <Columns>
                        <ea:GridColumn Align="Right" Caption="Element|A" DataMember="Element" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Sposób wliczania|B" DataMember="Sposob" runat="server" Total="Info"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Wartość brutto|C" DataMember="Brutto" runat="server" Total="Sum"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Naliczona podstawa|D=[(A-F)*E+F]-(składki ZUS)" DataMember="Podstawa" runat="server" Total="Sum"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Mnożnik|E" DataMember="Mnoznik" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Odchyłki|F" DataMember="Odchylki" runat="server"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
                <ea:Section runat="server" ID="scSrednia">
                    <font face="Tahoma" size="2">
                        <ea:DataLabel ID="dlSrednia" runat="server"></ea:DataLabel>
                    </font>
                </ea:Section>
                <br />
                <font face="Tahoma" size="2">
                    <b>II. DODATKI OKRESOWE</b>
                </font>
			    <ea:Grid id="Grid2" runat="server" OnBeforeRow="Grid2_OnBeforeRow"
                    GroupLine="{0}" GroupData0="Element" ShowGroupSum="true">
				    <Columns>
                        <ea:GridColumn Align="Right" Caption="Okres|||A" DataMember="Okres" runat="server" Width="21"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Sposób wliczania|||B" DataMember="Sposob" runat="server" Total="Info"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Wartość brutto|||C" DataMember="Brutto" runat="server" Total="Sum"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Nal. podstawa (pomniejszona o składki ZUS)|D" DataMember="Podstawa" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="W podwójnej wysokości||E" DataMember="Podwojona" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Ilość miesięcy|||F" DataMember="Mnoznik" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Odchyłki|||G" DataMember="Odchylki" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Współczynnik|||H" DataMember="Wspolczynnik" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Po uwzględnieniu współczynnika||I=D*H" DataMember="Wartosc" runat="server"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="Po uwzlędnieniu miesięcy||J=I/F" DataMember="Kwota" runat="server" Total="Sum"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
                <br />
                <font face="Tahoma" size="2">
                    <ea:DataLabel ID="dlPodsumowanie" runat="server"></ea:DataLabel>
                </font>
            <eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</form>
	</body>
</HTML>
